// Remplacement de Nominatim par Pelias pour la recherche d'adresses
window.onload = function() {
    var map = L.map('map').setView([12.3711, -1.5197], 10);
    var destinationMarker;
    var sourceMarker;

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors',
        minZoom: 1,
        maxZoom: 20
    }).addTo(map);

    var control = L.Routing.control({
        lineOptions: {
            styles: [{ color: '#839c49', opacity: 1, weight: 7 }]
        },
        router: new L.Routing.osrmv1({
            language: 'fr',
            profile: 'car'
        }),
        waypoints: [],
        createMarker: function(i, waypoint, n) {
            var marker = L.marker(waypoint.latLng, { draggable: true })
                .bindPopup(i === 0 ? "Point de départ" : "Point d'arrivée")
                .on('dragend', function(e) {
                    var newLatLng = e.target.getLatLng();
                    control.spliceWaypoints(i, 1, newLatLng);
                    updateMarkers();
                });
            return marker;
        },
        routeWhileDragging: true,
        show: false,
        draggableWaypoints: true
    }).addTo(map);

    function updateMarkers() {
        if (sourceMarker) {
            var sourceLatLng = control.getWaypoints()[0].latLng;
            sourceMarker.setLatLng(sourceLatLng);
        }
        if (destinationMarker) {
            var destinationLatLng = control.getWaypoints()[1].latLng;
            destinationMarker.setLatLng(destinationLatLng);
        }
    }

    // Fonction pour afficher les suggestions
    function afficherSuggestions(input, containerSuggestions, inputElement) {
        if (input.length < 2) {
            containerSuggestions.innerHTML = '';
            return;
        }

        var url = `https://api.pelias.geocode.earth/v1/autocomplete?text=${encodeURIComponent(input)}&boundary.country=BF&lang=fr&size=50`;

        fetch(url)
            .then(response => {
                if (!response.ok) {
                    throw new Error('Erreur réseau : ' + response.statusText);
                }
                return response.json();
            })
            .then(data => {
                console.log(data);
                containerSuggestions.innerHTML = '';
                if (data.features.length > 0) {
                    data.features.forEach(result => {
                        var suggestion = document.createElement('div');
                        suggestion.className = 'suggestion';
                        suggestion.textContent = result.properties.label;
                        suggestion.onclick = function() {
                            inputElement.value = result.properties.label;
                            var destinationLatLng = [result.geometry.coordinates[1], result.geometry.coordinates[0]];

                            if (inputElement === document.getElementById('source-search')) {
                                if (sourceMarker) {
                                    map.removeLayer(sourceMarker);
                                }
                                sourceMarker = L.marker(destinationLatLng, { draggable: true })
                                    .addTo(map)
                                    .bindPopup("Point de départ")
                                    .openPopup()
                                    .on('dragend', function(e) {
                                        var newLatLng = e.target.getLatLng();
                                        control.spliceWaypoints(0, 1, newLatLng);
                                        updateMarkers();
                                    });
                            } else {
                                if (destinationMarker) {
                                    map.removeLayer(destinationMarker);
                                }
                                destinationMarker = L.marker(destinationLatLng, { draggable: true })
                                    .addTo(map)
                                    .bindPopup("Point d'arrivée")
                                    .openPopup()
                                    .on('dragend', function(e) {
                                        var newLatLng = e.target.getLatLng();
                                        control.spliceWaypoints(1, 1, newLatLng);
                                        updateMarkers();
                                    });
                            }
                            containerSuggestions.innerHTML = '';
                        };
                        containerSuggestions.appendChild(suggestion);
                    });
                }
            })
            .catch(error => {
                console.error("Erreur lors de la récupération des suggestions : ", error);
            });
    }

    document.getElementById('source-search').addEventListener('input', function() {
        var input = this.value;
        var containerSuggestions = document.getElementById('source-suggestions');
        afficherSuggestions(input, containerSuggestions, this);
    });

    document.getElementById('destination-search').addEventListener('input', function() {
        var input = this.value;
        var containerSuggestions = document.getElementById('destination-suggestions');
        afficherSuggestions(input, containerSuggestions, this);
    });
};
